/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_TSS_INTERFACE_H
#define _SCE_TSS_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce { 
	namespace Toolkit {
	namespace NP {

	/// @brief
	/// The namespace containing PSN TSS (title small storage) functionality.
	///	
	/// The namespace containing PSN TSS (title small storage) functionality.
	namespace TSS {

	/// @brief
	/// The external interface to the PSN TSS (title small storage) functionality.
	///	
	/// The external interface to the PSN TSS (title small storage) functionality.
	/// This class is used to obtain data from the a TSS server.
	class Interface
	{
	public:

		/// @brief 
		/// Retrieves TSS data from a TSS server.
		///
		/// Retrieves TSS data from a TSS server.
		/// 
		/// @param	data			A pointer to the <c>Future</c> object that will hold the TSS data.
		/// @param	async			A flag that indicates whether the function is non-blocking or blocking.
		///							Defaults to true so the function is non-blocking by default.
		///
		/// @retval				SCE_TOOLKIT_NP_SUCCESS					The operation was successful.							 
		/// @retval				SCE_TOOLKIT_NP_INVALID_POINTER			The operation failed because an invalid pointer was passed to the <c><i>data</i></c> parameter.
		/// @retval				SCE_TOOLKIT_NP_NOT_INITIALISED			The operation failed because the %NP %Toolkit library is not initialized.
		///
		static int getData(sce::Toolkit::NP::Utilities::Future<TssData> *data, bool async = true);
	};
	}
}
}//end Toolkit::NP
}//end Sce
#endif
